/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Platform;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.io.IOException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;

public class JameicaSecurityManager
extends SecurityManager {
    private static final long TIMEOUT = 300000L;
    private AtomicInteger privCount = new AtomicInteger();
    private String jameicaPath = null;
    private long lastAsked = 0L;

    public JameicaSecurityManager() {
        try {
            this.jameicaPath = new File(".").getCanonicalPath() + File.separator;
            Logger.info((String)("protecting program dir " + this.jameicaPath));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to determine absolute path for " + new File(".").getAbsolutePath(), e);
        }
    }

    @Override
    public void checkDelete(String file) {
        this.checkFile(file);
        super.checkDelete(file);
    }

    @Override
    public void checkWrite(String file) {
        this.checkFile(file);
        super.checkWrite(file);
    }

    private void checkFile(String path) {
        if (path == null) {
            return;
        }
        if (this.privCount.get() > 0) {
            Logger.debug((String)("[privcount: " + this.privCount.get() + "] in privileged mode - disabled check for " + path));
            return;
        }
        try {
            File pluginDir;
            String pluginPath;
            this.privCount.incrementAndGet();
            File check = new File(path);
            if (!Platform.inProgramDir(check)) {
                return;
            }
            String s = check.getCanonicalPath();
            if (!s.startsWith(pluginPath = (pluginDir = Application.getConfig().getSystemPluginDir()).getCanonicalPath() + File.separator)) {
                throw new ApplicationException(Application.getI18n().tr("Schreibzugriff auf {0} verweigert", s));
            }
            if (pluginDir.canWrite()) {
                Logger.debug((String)("[privcount: " + this.privCount.get() + "] trying to write in system plugin dir for: " + path));
                long now = System.currentTimeMillis();
                if (this.lastAsked + 300000L > now) {
                    Logger.debug((String)("[privcount: " + this.privCount.get() + "] write access to " + path + " allowed by user authorization"));
                    return;
                }
                boolean b = Application.getCallback().askUser(Application.getI18n().tr("Schreibzugriff in System-Plugin-Ordner erlauben?\n\nOrdner: {0}", pluginPath));
                Logger.info((String)("[privcount: " + this.privCount.get() + "] write access to " + path + " authorized: " + b));
                if (b) {
                    this.lastAsked = System.currentTimeMillis();
                    return;
                }
            }
            try {
                throw new ApplicationException(Application.getI18n().tr("Schreibzugriff auf {0} verweigert", s));
            }
            catch (OperationCanceledException oce) {
                throw new SecurityException(Application.getI18n().tr("Vorgang abgebrochen"));
            }
            catch (ApplicationException ae) {
                throw new SecurityException(ae.getMessage(), ae);
            }
            catch (Exception e) {
                throw new SecurityException(Application.getI18n().tr("Pr\u00fcfen der Schreib-Berechtigung auf {0} fehlgeschlagen", path), e);
            }
        }
        finally {
            this.privCount.decrementAndGet();
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
    }

    public <T> T doPrivileged(PrivilegedAction<T> action) {
        try {
            Logger.info((String)("[privcount: " + this.privCount.get() + "] starting privileged action: " + action));
            this.privCount.incrementAndGet();
            T t = action.run();
            return t;
        }
        finally {
            this.privCount.decrementAndGet();
            Logger.info((String)("[privcount: " + this.privCount.get() + "] finished privileged action: " + action));
        }
    }
}

